IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Asiento_Numerar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Asiento_Numerar
END
GO


CREATE FUNCTION CF_Asiento_Numerar ( @pId_Plan_Cta INT, @pFecha DATETIME )
RETURNS INT
AS
BEGIN

DECLARE @Metodo INT,
		@Retorno INT


SET @Metodo = 	dbo.CF_xParam('Tipo_Numero_Asiento')

IF @Metodo = 1
BEGIN
	SET @Retorno = (SELECT  MAX(Nro) + 1 as Nro FROM Asientos WHERE Id_Plan_Cta = @pId_Plan_Cta ) 
END
ELSE
BEGIN
	SET @Retorno = (SELECT ISNULL(MAX(Nro),0) + 1 as Nro 
		          FROM Asientos
				  WHERE Id_Plan_Cta = @pId_Plan_Cta 
		   	      AND DATEPART(mm,@pFecha) = DATEPART(mm,Fecha)
				  AND DATEPART(yy,@pFecha) = DATEPART(yy,Fecha)
				  )
				  
END
RETURN ISNULL(@Retorno,1)
END  

/*
select  dbo.CF_Asiento_Numerar(6,'20220205')

SELECT dbo.CF_Asiento_Numerar(6,'81029')

*/